--========================================================--
-- Unseasonal Weather - DynamicRadio Channel (Server helper)
-- Registra el canal UW-RF-001 en DynamicRadio al cargar scripts.
--========================================================--

if not UW_RF then UW_RF = {} end

local UW_RF_UUID = "UW-RF-001"
local UW_RF_FREQ = 92700 -- 92.7 MHz

local function ensureChannel(scriptManager)
    if not DynamicRadio then return end
    DynamicRadio.channels = DynamicRadio.channels or {}

    -- ya existe en la lista?
    for _, ch in ipairs(DynamicRadio.channels) do
        if ch.uuid == UW_RF_UUID then
            return
        end
    end

    table.insert(DynamicRadio.channels, {
        name     = "Unseasonal Weather Network",
        freq     = UW_RF_FREQ,
        category = "Emergency",
        uuid     = UW_RF_UUID,
        register = true,
    })

    -- registrar de inmediato o crear directo si es posible
    if DynamicRadioChannel and DynamicRadioChannel.new then
        local cat = ChannelCategory and ChannelCategory.Emergency or ChannelCategory.Other
        local dynamicChannel = DynamicRadioChannel.new("Unseasonal Weather Network", UW_RF_FREQ, cat, UW_RF_UUID)
        if dynamicChannel then
            if scriptManager and scriptManager.AddChannel then
                scriptManager:AddChannel(dynamicChannel, false)
            end
            DynamicRadio.cache = DynamicRadio.cache or {}
            DynamicRadio.cache[UW_RF_UUID] = dynamicChannel
        end
    end
end

local function onLoadRadioScripts(scriptManager, isNewGame)
    ensureChannel(scriptManager)
end

Events.OnLoadRadioScripts.Add(onLoadRadioScripts)
